/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.world.chunk;

import java.util.Comparator;
import net.jayjay.dangerzone.entity.EntityPlayer;
import net.jayjay.dangerzone.world.Frustum;
import net.jayjay.dangerzone.world.chunk.Chunk;

public class DirtyChunkSorter
implements Comparator<Chunk> {
    private final EntityPlayer player;
    private final Frustum frustum;
    private volatile long now;

    public DirtyChunkSorter(EntityPlayer player, Frustum frustum) {
        this.player = player;
        this.frustum = frustum;
        this.now = System.currentTimeMillis();
    }

    public void updateTimestamp() {
        this.now = System.currentTimeMillis();
    }

    @Override
    public int compare(Chunk c0, Chunk c1) {
        boolean i1;
        boolean i0 = this.frustum.isVisible(c0.aabb);
        if (i0 != (i1 = this.frustum.isVisible(c1.aabb))) {
            return i0 ? -1 : 1;
        }
        long t0 = this.now - c0.dirtiedTime;
        long t1 = this.now - c1.dirtiedTime;
        if (t0 != t1) {
            return Long.compare(t0, t1);
        }
        double dist0 = c0.distanceToSqr(this.player);
        double dist1 = c1.distanceToSqr(this.player);
        return Double.compare(dist0, dist1);
    }

    @Deprecated
    public int comparebutobject(Object var1, Object var2) {
        return this.compare((Chunk)var1, (Chunk)var2);
    }
}

